import { LazyDropdown } from '@yandex-infracloud-ui/libs-next';
import { Button } from '@yandex-data-ui/common';
import * as React from 'react';
import { SyntheticEvent, useCallback, useState } from 'react';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { UserSelectMode } from '../UserSelect/UserSelect';

import styles from './FindUserButton.module.css';
import { FindUserPopup } from './FindUserPopup';
import { AddIcon } from 'design/icons';

interface IProps {
   mode: UserSelectMode;
   selected: Set<string>;
   submitLabel?: string;
   title?: string;

   onSelect(e: SyntheticEvent | null, login: string | null): void;
}

export const FindUserButton = React.memo(
   ({ mode, onSelect, selected, submitLabel = 'Select', title = 'Select user' }: IProps) => {
      // hooks
      const [opened, setOpened] = useState(false);

      // handlers
      const onChangeOpened = useCallback((v: boolean) => setOpened(v), []);

      const close = useCallback(() => setOpened(false), []);

      const submit = useCallback(
         (e: SyntheticEvent | null, login: string | null) => {
            if (login) {
               onSelect(e, login);
               close();
            }
         },
         [close, onSelect],
      );

      // render
      const switcher = (
         <Button view={'clear'} size={'s'} className={styles.findUserButton}>
            <AddIcon />
         </Button>
      );

      return (
         <LazyDropdown switcher={switcher} opened={opened} onChangeOpened={onChangeOpened}>
            <FindUserPopup
               mode={mode}
               onCancel={close}
               onSubmit={submit}
               submitLabel={submitLabel}
               title={title}
               value={selected}
            />
         </LazyDropdown>
      );
   },
);

FindUserButton.displayName = 'FindUserButton';
