import {
   classNames,
   IPureValueProps,
   IUserOrGroup,
   styleHelpers,
   toggleSetItem,
   UserOrGroupType,
} from '@yandex-infracloud-ui/libs-next';
import { SystemUsersContext, UserName } from '@yandex-infracloud-ui/libs';
import { Checkbox } from '@yandex-data-ui/common';
import * as React from 'react';
import { SyntheticEvent, useCallback, useContext, useMemo } from 'react';

import classes from './SystemUsersSelector.module.css';

interface Props extends IPureValueProps<Set<string>> {
   className?: string;
}

export function SystemUsersSelector({ className, value, onChange }: Props) {
   const systemUsers = useContext(SystemUsersContext);

   const users = useMemo(
      () =>
         Array.from(systemUsers).map(
            ([, user]) =>
               ({
                  id: user.login,
                  name: user.login,
                  type: UserOrGroupType.System,
               } as IUserOrGroup),
         ),
      [systemUsers],
   );

   const handleChange = useCallback(
      (e: SyntheticEvent) => {
         const t = e.target as HTMLInputElement;
         onChange(toggleSetItem(value, t.name));
      },
      [onChange, value],
   );

   return (
      <div className={className}>
         {users.map(user => (
            <>
               <div key={user.id}>
                  <Checkbox
                     size={'m'}
                     className={classNames(classes.item, styleHelpers.rightSpace)}
                     name={user.id}
                     checked={value.has(user.id)}
                     onChange={handleChange}
                     content={
                        // eslint-disable-next-line react/jsx-wrap-multilines
                        <>
                           Include <UserName value={user} className={classes.name} /> issuer
                        </>
                     }
                  />
               </div>
            </>
         ))}
      </div>
   );
}
