import React, { useEffect } from 'react';
import { useFormikContext } from 'formik';

interface Props {
   onChange(v: any): void;
}

export const FormChangeListener: React.FC<Props> = React.memo(({ onChange }) => {
   const form = useFormikContext();

   useEffect(() => {
      onChange(form.values);
   }, [form.values, onChange]);

   return null;
});

FormChangeListener.displayName = 'FormChangeListener';
