import { storiesOf } from '@storybook/react';
import { default as React, SyntheticEvent, useState } from 'react';
import { IHbfProject } from '../../models';

import { outlineDecorator } from '../../stories';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { DevJson } from '../DevJson/DevJson';

import { HbfProjectInput } from './HbfProjectInput';

function RegularStory() {
   // hooks
   const [value, setValue] = useState('');

   // handlers
   const onSelect = (e: SyntheticEvent | null, v: IHbfProject | null) => setValue(v ? v.id : '');

   const updateValue = (e: SyntheticEvent | null, q: string) => setValue(q);

   // render
   return (
      <>
         <HbfProjectInput initialQuery={value} onSelect={onSelect} onQueryUpdate={updateValue} />
         <DevJson>{value}</DevJson>
      </>
   );
}

storiesOf('shared|hbf_project_input/HbfProjectInput', module)
   .addDecorator(outlineDecorator)
   .add('regular', () => <RegularStory />);
