import { Suggest } from '@yandex-data-ui/common';
import React, { useCallback } from 'react';
import { SyntheticEvent } from 'react';

import { IHbfProject } from '../../models';
import { SuggestSelectItem } from 'shared';

import { HbfProjectView } from './HbfProjectView';

import { strategy } from './strategy';

interface IProps {
   autofocus?: boolean;
   clearOnSelect?: boolean;
   cls?: string;
   disabled?: boolean;
   initialQuery?: string;
   name?: string;

   onSelect(e: SyntheticEvent | null, item: IHbfProject | null): void;

   onQueryUpdate(e: SyntheticEvent | null, q: string): void;
}

export const HbfProjectInput = React.memo((props: IProps) => {
   const { onQueryUpdate, onSelect, initialQuery, disabled } = props;

   const handleChange = useCallback(
      (v: string) => {
         onQueryUpdate(null, v || '');
      },
      [onQueryUpdate],
   );
   const handleClick = useCallback(
      (v: IHbfProject) => {
         onSelect(null, v || null);
      },
      [onSelect],
   );

   const handleGetItems = useCallback(async (query): Promise<IHbfProject[] | any> => {
      if (!query) return [];

      return strategy
         .load(query)
         .toPromise()
         .then(resp => resp.slice(0, 10));
   }, []);

   return disabled ? (
      <HbfProjectView id={initialQuery!} />
   ) : (
      <Suggest
         getItems={handleGetItems}
         text={initialQuery}
         getItemsOnMount={true}
         onUpdate={handleChange}
         onItemClick={handleClick}
         onInputEnterKeyDown={handleChange}
         applicableInputValue={true}
         placeholder={'Select MTN'}
         renderItem={item => (
            <SuggestSelectItem title={`0x${item.id.replace(/^0x/, '')}`} desc={item.name ? `: ${item.name}` : null} />
         )}
         disabled={disabled}
         debounce={500}
         syncPopupOnResize={false}
      />
   );
});

HbfProjectInput.displayName = 'HbfProjectInput';
