import { classNames } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

import { IHbfProject } from '../../models';

import styles from './HbfProjectItem.module.css';

export const HbfProjectItem = React.memo(({ item }: { item: IHbfProject }) => (
   <div className={classNames(styles.suggestItem, styles.withPaddings)}>
      {`0x${item.id.replace(/^0x/, '')}`}
      <span className={styles.suggestItemTitle}>{item.name ? `: ${item.name}` : null}</span>
   </div>
));

HbfProjectItem.displayName = 'HbfProjectItem';
