import { EMPTY_VALUE, SuggestLayer, useObservableValue } from '@yandex-infracloud-ui/libs-next';
import { toasts } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { dictApi } from '../../services';

import { HbfProjectItem } from './HbfProjectItem';

function getDefaultHbfProject(id: string) {
   return {
      id,
      layer: 'hbf' as SuggestLayer,
      name: '...',
      title: '',
      url: '',
   };
}

export const HbfProjectView = React.memo(({ id }: { id: string }) => {
   if (!id) {
      return <>{EMPTY_VALUE}</>;
   }

   // hooks
   const item = useObservableValue(dictApi.getHbfProject(id), toasts.handleApiError('Get MTN project'), [id]); // eslint-disable-line react-hooks/rules-of-hooks

   return <HbfProjectItem item={item || getDefaultHbfProject(id)} />;
});

HbfProjectView.displayName = 'HbfProjectView';
