import { getWeightedSuggestions, ISuggestStrategy } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';

import { IHbfProject } from '../../models';
import { dictApi } from '../../services';

import { SuggestSelectItem } from 'shared';

class HbfProjectStrategy implements ISuggestStrategy {
   public PAGE_SIZE = 100;

   public getPlaceholder(): string {
      return 'Select MTN';
   }

   public getQueryFromEntity(entity: IHbfProject): string {
      return entity ? entity.id : '';
   }

   public load(query: string): Observable<IHbfProject[]> {
      const q = query.toLowerCase().replace(/^0x/, '');

      return dictApi.getHbfProjects().pipe(
         map(items =>
            getWeightedSuggestions(
               items,
               item => this._convertToSuggestItem(item),
               this.PAGE_SIZE,
               item => (item.id === q ? 0 : null),
               item => (item.id.startsWith(q) ? 1 : null),
               item => (item.name.toLowerCase().includes(q) ? 10 : null),
            ),
         ),
      );
   }

   public renderItem(item: IHbfProject): JSX.Element {
      return <SuggestSelectItem title={`0x${item.id.replace(/^0x/, '')}`} desc={item.name ? `: ${item.name}` : null} />;
   }

   private _convertToSuggestItem(entity: IHbfProject): IHbfProject {
      return {
         ...entity,

         id: entity.id,
         title: entity.name,
      };
   }
}

export const strategy: ISuggestStrategy = new HbfProjectStrategy();
