import { text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import { toQuery } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { ROUTE_LINKS } from '../../models';
import { outlineDecorator, routerDecorator } from '../../stories';

import { HeaderWithBackLink } from './HeaderWithBackLink';

const fakeEmptyLocation = {
   state: null,
} as any;

const fakeLocation = {
   state: {
      prev: {
         pathname: '/back-url',
         search: toQuery({ q: 'test' }),
      },
   },
} as any;

storiesOf('shared/HeaderWithBackLink', module)
   .addDecorator(outlineDecorator)
   .addDecorator(routerDecorator)
   .add('Without back state', () => (
      <HeaderWithBackLink
         text={text('text', 'New automation plot')}
         url={ROUTE_LINKS.home()}
         location={fakeEmptyLocation}
      />
   ))
   .add('With prev state', () => (
      <HeaderWithBackLink text={text('text', 'New automation plot')} url={ROUTE_LINKS.home()} location={fakeLocation} />
   ));
