import * as H from 'history';
import * as React from 'react';
import { PropsWithChildren } from 'react';
import { Link } from 'react-router-dom';

import styles from './HeaderWithBackLink.module.css';

import { ArrowLeftIcon } from 'design/icons';

interface IProps {
   location: H.Location<{ prev: any }>;
   text: string;
   url: string;
}

export const HeaderWithBackLink = React.memo(({ children, url, text, location }: PropsWithChildren<IProps>) => {
   const to = location.state && location.state.prev ? location.state.prev : url;

   return (
      <div data-e2e={'HeaderWithBackLink'} className={styles.link}>
         <Link data-e2e={'HeaderWithBackLink:link'} to={to} className={styles.back}>
            <ArrowLeftIcon className={styles.icon} size={'2x'} />
         </Link>
         <h1 data-e2e={'HeaderWithBackLink:header'} className={styles.header}>
            {text}
         </h1>
         {children}
      </div>
   );
});

HeaderWithBackLink.displayName = 'HeaderWithBackLink';
