import { isEmpty, styleHelpers, useDismounted } from '@yandex-infracloud-ui/libs-next';
import React, { useEffect } from 'react';
import { takeUntil } from 'rxjs/operators';
import { projectApi } from 'services';

import { EXTERNAL_LINKS, IBoxes, IProjectBoxes, IBoxesEine } from '../../models';

import { ITab } from '../Tabs';

interface IProps {
   cls?: string;
   project?: string;
   inv: number;
   name: string;
   boxes?: IBoxes | null;
}

const getLinks = (name: string, inv: number, host?: IBoxesEine) => [
   name ? { header: 'Bot', id: 'bot', url: EXTERNAL_LINKS.bot(inv) } : null,
   name
      ? {
           header: 'Eine',
           id: 'eine',
           url: EXTERNAL_LINKS.eine(name, host?.eine_host),
        }
      : null,
   name
      ? {
           header: 'Setup (LUI)',
           id: 'lui',
           url: EXTERNAL_LINKS.lui(name, host?.deploy_host),
        }
      : null,
   name ? { header: 'Juggler', id: 'juggler', url: EXTERNAL_LINKS.juggler(name) } : null,
   name ? { header: 'RTC', id: 'rtc', url: EXTERNAL_LINKS.rtc(name) } : null,
   { header: 'iKVM', id: 'ikvm', url: EXTERNAL_LINKS.inv(inv, host?.ipmiproxy_host) },
];

export const HostLinks = React.memo(({ cls = '', name, inv, project = '', boxes }: IProps) => {
   const [projectBoxes, setProjectBoxes] = React.useState<IProjectBoxes>();
   const dismounted = useDismounted();

   const [links, setLinks] = React.useState<(ITab | null)[]>(getLinks(name, inv));

   // получаем к каким boxes привязан проект
   useEffect(() => {
      projectApi
         .getById(project, ['boxes'])
         .pipe(takeUntil(dismounted))
         .subscribe(v => setProjectBoxes(v.boxes));
   }, [dismounted, project]);

   // меняем ссылки с учетом привязанных boxes
   useEffect(() => {
      if (projectBoxes && !isEmpty(projectBoxes.eine)) {
         setLinks(getLinks(name, inv, boxes?.eine?.[projectBoxes.eine]));
      }
   }, [boxes, inv, name, projectBoxes]);

   return (
      <nav className={cls}>
         {links.filter(Boolean).map(link => (
            <a
               key={link!.id}
               href={link!.url}
               target={'_blank'}
               rel={'noopener noreferrer'}
               className={styleHelpers.externalGrayLink}
            >
               {link!.header}
            </a>
         ))}
      </nav>
   );
});

HostLinks.displayName = 'HostLinks';
