import React from 'react';

import { fullWidthOutlineDecorator } from '../../stories';
import { IStoryDefaults } from '../../stories/typings';

import { InnerScrollPage } from './InnerScrollPage';

export const WithHeader = () => (
   <InnerScrollPage header={<h1>Header</h1>}>
      <div style={{ maxHeight: '100%', overflowY: 'auto' }}>
         <div style={{ backgroundColor: 'yellow', height: 1000 }}>content 1000px</div>
      </div>
   </InnerScrollPage>
);

const style = {
   ['--side-padding' as any]: '2rem',
} as Partial<CSSStyleDeclaration>;

export default {
   decorators: [story => <div style={style as any}>{story()}</div>, fullWidthOutlineDecorator],
   title: 'shared|InnerScrollPage',
} as IStoryDefaults;
