import React, { ReactNode } from 'react';
import { useBodyScroll } from '../reactHooks';

import classes from './InnerScrollPage.module.css';

interface Props {
   header: ReactNode;
}

export const InnerScrollPage: React.FC<Props> = ({ header, children }) => {
   useBodyScroll('initial');

   return (
      <div className={classes.page}>
         <header className={classes.header}>{header}</header>
         <main className={classes.main}>{children}</main>
      </div>
   );
};

InnerScrollPage.displayName = 'InnerScrollPage';
