import { json, WEEK_IN_SEC } from '@yandex-infracloud-ui/libs';
import { addSeconds } from 'date-fns';
import React, { useMemo } from 'react';
import { IStoryDefaults } from '../../stories/typings';

import { IsActualWrapper } from './IsActualWrapper';

const Story = ({ secondsFromNow }: { secondsFromNow: number }) => {
   const timeout = useMemo(() => {
      return Math.ceil(addSeconds(new Date(), secondsFromNow).getTime() / 1000);
   }, [secondsFromNow]);

   return (
      <>
         <pre>{json({ secondsFromNow, timeout })}</pre>
         <IsActualWrapper timeout={timeout}>{isActual => (isActual ? <div>YES</div> : <div>NO</div>)}</IsActualWrapper>
      </>
   );
};

export const AlwaysActual = () => <Story secondsFromNow={WEEK_IN_SEC} />;

export const Timeout5Seconds = () => <Story secondsFromNow={5} />;

export const NotActual = () => <Story secondsFromNow={-5} />;

export default {
   title: 'shared|IsActualWrapper',
} as IStoryDefaults;
