import React, { ReactElement } from 'react';

import { useIsActual } from '../reactHooks';

interface Props {
   children: (isActual: boolean) => ReactElement | null;

   /**
    * Временная метка актуальности (до этой метки значение считается актуальным)
    *
    * Задаётся в секундах
    */
   timeout: number;
}

export const IsActualWrapper: React.FC<Props> = React.memo(({ timeout, children }) => {
   const isActual = useIsActual(timeout);

   return children(isActual);
});

IsActualWrapper.displayName = 'IsActualWrapper';
