import { storiesOf } from '@storybook/react';
import { json } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { IssuerList } from './IssuerList';

const initial = ['khoden@', 'wall-e', 'idm'];

function RegularStory() {
   // hooks
   const [value, setValue] = useState(new Set(initial));

   // handlers
   const change = (e: SyntheticEvent | null, v: Set<string>) => setValue(v);

   // render
   return (
      <>
         <IssuerList editable={true} value={value} onChange={change} forceAvatars={true} />

         <pre>{json(value)}</pre>
      </>
   );
}

storiesOf('shared|IssuerList', module).add('regular', () => <RegularStory />);
