import { IUserOrGroup, UserList, UserOrGroupType } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { SyntheticEvent, useCallback, useEffect, useState } from 'react';
import { SYSTEM_USERS } from '../../models';

interface IProps {
   cls?: string;
   editable: boolean;
   forceAvatars?: boolean;
   value: Set<string>;

   onChange?(e: SyntheticEvent | null, v: Set<string>): void;
}

export function outToIn(owners: Set<string>): IUserOrGroup[] {
   return Array.from(owners).map(v => {
      if (SYSTEM_USERS.has(v)) {
         return { type: UserOrGroupType.System, id: v };
      }

      return v.endsWith('@')
         ? { type: UserOrGroupType.People, id: v.replace(/@$/, '') }
         : { type: UserOrGroupType.Group, id: v }; // По идее группы быть не должно
   });
}

export function intToOut(issuers: IUserOrGroup[]): Set<string> {
   return new Set(
      Array.from(issuers).map(v => {
         if (v.type === UserOrGroupType.System) {
            return v.id;
         }

         return v.type === UserOrGroupType.People ? `${v.id}@` : v.id; // Не должно сюда заходить
      }),
   );
}

/**
 * Хак, для того чтобы конвертировать магию с owners (разное расположение собачек)
 *
 * Для issuer собака в конце - признак человека. Без собаки только системный 'walle'.
 */
export const IssuerList = React.memo(({ editable, onChange, value: propValue, ...props }: IProps) => {
   // hooks
   const [value, setValue] = useState<IUserOrGroup[]>([]);

   // effects
   useEffect(() => {
      setValue(outToIn(propValue));
   }, [propValue]);

   // handlers
   const update = useCallback(
      (e: SyntheticEvent | null, v: IUserOrGroup[]) => {
         if (!editable) {
            return;
         }

         setValue(v);

         if (onChange) {
            onChange(e, intToOut(v));
         }
      },
      [editable, onChange],
   );

   return <UserList {...props} editable={editable} onChange={update} value={value} />;
});

IssuerList.displayName = 'IssuerList';
