import { storiesOf } from '@storybook/react';
import { json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';
import { IdmRequest } from '../../models';
import { OwnersList } from './OwnersList';

function SetAsValue() {
   // hooks
   const [value, setValue] = useState(new Set(['artgromov', 'mbabich', 'stunder', 'wint', 'xifos', '@svc_rtcsupport']));

   // handlers
   const change = (e: SyntheticEvent | null, v: Set<string>) => setValue(v);

   // render
   return (
      <>
         <OwnersList editable={true} value={value} onChange={change} forceAvatars={true} />

         <pre>{json(value)}</pre>
      </>
   );
}

function MapAsValue() {
   // hooks
   const [value, setValue] = useState(
      new Map<string, IdmRequest>([
         ['khoden', { id: 123, login: 'khoden' }],
         ['mertas', { id: 321, login: 'mertas' }],
      ]),
   );

   // handlers
   const change = (e: SyntheticEvent | null, v: Map<string, IdmRequest>) => setValue(v);

   // render
   return (
      <>
         <OwnersList editable={true} value={value} onChange={change} forceAvatars={true} />

         <pre>{json(value)}</pre>
      </>
   );
}

storiesOf('shared|OwnersList', module)
   .add('SetAsValue', () => <SetAsValue />)
   .add('MapAsValue', () => <MapAsValue />);
