import { intToOut, outToIn, Owners } from './OwnersList';

describe('shared|OwnersList', () => {
   it('outToIn is full opposition of itToOut', () => {
      function test(v: Owners) {
         expect(intToOut(outToIn(v), v)).toEqual(v);
      }

      test(new Set(['xx', 'yy']));
      test(new Set(['xx', '@yy']));
      test(new Set(['xx@', 'yy']));
      test(
         new Map([
            ['xx@', { id: 1111, login: 'xx@' }],
            ['yy', { id: 2222, login: 'yy' }],
         ]),
      );
   });
});
