import React from 'react';
import { fullWidthOutlineDecorator } from '../../stories';
import { IStoryDefaults } from '../../stories/typings';
import { Page } from './Page';

export const WithoutHeader = () => (
   <Page>
      <div style={{ backgroundColor: 'yellow', height: 1000 }}>content 1000px</div>
   </Page>
);

export const WithHeader = () => (
   <Page header={<h1>Header</h1>}>
      <div style={{ backgroundColor: 'yellow', height: 1000 }}>content 1000px</div>
   </Page>
);

export default {
   decorators: [
      story => <div style={{ ['--side-padding' as any]: '2rem' } as any}>{story()}</div>,
      fullWidthOutlineDecorator,
   ],
   title: 'shared|Page',
} as IStoryDefaults;
