import { classNames, WindowTitle } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { PropsWithChildren, ReactNode } from 'react';

import classes from './Page.module.css';

interface Props {
   className?: string;
   header?: ReactNode;
   title?: string;
}

export const Page = ({ className, title, header, children }: PropsWithChildren<Props>) => (
   <>
      {title ? <WindowTitle value={title} /> : null}

      <div className={classNames(classes.page, className)}>
         {header ? <header className={classes.header}>{header}</header> : <div className={classes.fakeHeader} />}
         <main className={classes.main}>{children}</main>
      </div>
   </>
);

Page.displayName = 'Page';
