import { IListOption, IValueProps, styleHelpers } from '@yandex-infracloud-ui/libs';
import { CheckBox } from 'lego-on-react';
import * as React from 'react';

interface IProps extends IValueProps<Set<string>> {
   options: IListOption[];
   visible: boolean;
}

export const ProjectGroupCheckbox = React.memo(({ visible, options, value, onChange }: IProps) => {
   if (!visible || options.length === 0) {
      return null;
   }

   const isSelected = options.every(o => value.has(o.value));

   const toggle = () => {
      const newValue = new Set(value);

      if (isSelected) {
         options.forEach(o => newValue.delete(o.value));
      } else {
         options.forEach(o => newValue.add(o.value));
      }
      onChange(null, newValue);
   };

   return <CheckBox theme={'normal'} size={'s'} cls={styleHelpers.rightSpace} checked={isSelected} onChange={toggle} />;
});

ProjectGroupCheckbox.displayName = 'ProjectGroupCheckbox';
