import { createSelector } from '@reduxjs/toolkit';
import React, { useCallback } from 'react';
import { useSelector } from 'react-redux';

import { RootState } from '../../state/store';
import { useProjectsLoadEnsure } from '../reactHooks';

interface IProps {
   id: string;
}

const selectProjectsByIds = createSelector(
   (s: RootState, projectId: string) => projectId,
   (s: RootState) => s.projects,
   (id, projects) => projects.allItems.byIds[id],
);

export const ProjectName = React.memo(({ id }: IProps) => {
   const projectSelector = useCallback((s: RootState) => selectProjectsByIds(s, id), [id]);
   const project = useSelector(projectSelector);

   useProjectsLoadEnsure();

   return <>{project ? project.name : id}</>;
});

ProjectName.displayName = 'ProjectName';
