import { action } from '@storybook/addon-actions';
import { modalService, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';

import { modalsSupportDecorator } from '../../stories';
import { IStoryDefaults } from '../../stories/typings';

import { ReasonModal } from './ReasonModal';

export const Regular = () => <ReasonModal ok={action('ok')} cancel={action('cancel')} />;

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(ReasonModal, { reason: 'Reason' })
         .pipe(takeUntil(dismounted))
         .subscribe(v => action('success')(v), action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};

export default {
   decorators: [modalsSupportDecorator],
   title: 'shared|ReasonModal',
} as IStoryDefaults;
