import React, { useCallback, PropsWithChildren } from 'react';
import { classNames, DISMISS_REASON, IModalProps, Loader, ModalLayout } from '@yandex-infracloud-ui/libs';
import classes from '../../design/commonModals.module.css';
import { Button } from 'lego-on-react';
import { Form, Formik } from 'formik';
import { ReasonField } from '../../rich_shared/form_fields2/ReasonField';
import { reasonFormValidationSchema } from './ReasonModalValidation';

export interface ReasonForm {
   reason: string;
}

const initialValue: ReasonForm = {
   reason: '',
};

const InternalForm: React.FC<PropsWithChildren<{}>> = ({ children }) => (
   <Form className={classes.form}>
      <ReasonField />

      {children}
   </Form>
);

export const ReasonModal: React.FC<IModalProps<ReasonForm>> = React.memo(({ ok, cancel }) => {
   const handleSubmit = useCallback((v: ReasonForm) => ok(v), [ok]);

   const dismiss = useCallback(() => cancel(DISMISS_REASON), [cancel]);

   return (
      <ModalLayout onDismiss={dismiss} showFooter={false} title={'Enter a reason'}>
         <Formik initialValues={initialValue} onSubmit={handleSubmit} validationSchema={reasonFormValidationSchema}>
            {form => (
               <InternalForm>
                  <footer className={classes.footer}>
                     <Loader visible={form.isSubmitting} inline={true} text={'In progress'} />

                     <Button
                        theme={'clear'}
                        size={'s'}
                        cls={classes.button}
                        onClick={dismiss}
                        disabled={form.isSubmitting}
                     >
                        Cancel
                     </Button>

                     <Button
                        theme={'action'}
                        size={'s'}
                        cls={classNames(classes.button)}
                        type={'submit'}
                        disabled={!form.isValid || form.isSubmitting}
                     >
                        Ok
                     </Button>
                  </footer>
               </InternalForm>
            )}
         </Formik>
      </ModalLayout>
   );
});

ReasonModal.displayName = 'ReasonModal';
