import { classNames, styleHelpers, useBehaviourSubject } from '@yandex-infracloud-ui/libs-next';
import React from 'react';

import { globalState, IHost } from '../../models';
import { config } from '../../services';
import { useCanEditHost } from '../reactHooks';

import classes from './RequestHostAccessLink.module.css';

interface Props {
   host: IHost;
}

export const RequestHostAccessLink: React.FC<Props> = ({ host }) => {
   const user = useBehaviourSubject(globalState.user);
   const canEdit = useCanEditHost(host);
   if (!user || canEdit) {
      return null;
   }

   return (
      <a
         href={config.getIdmRequestHostAccessUrl(user.login, host.name)}
         target={'_blank'}
         rel={'noopener noreferrer'}
         className={classNames(styleHelpers.externalGrayLink, classes.link)}
      >
         Request access
      </a>
   );
};

RequestHostAccessLink.displayName = 'RequestHostAccessLink';
