import { boolean } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import { json } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';
import { reduxStoryDecorator } from 'stories';

import { RestrictionEditor } from './RestrictionEditor';

interface IProps {
   disabled: boolean;
}

const RestrictionEditorStory = ({ disabled }: IProps) => {
   // hooks
   const [value, setValue] = useState(new Set(['automated-healing']));

   // handlers
   const onChange = (e: SyntheticEvent, v: Set<string>) => setValue(v);

   // render
   return (
      <div style={{ display: 'flex' }}>
         <RestrictionEditor disabled={disabled} value={value} onChange={onChange} />

         <RestrictionEditor disabled={disabled} value={value} onChange={onChange} />

         <pre>{json(value)}</pre>
      </div>
   );
};

storiesOf('shared', module)
   .addDecorator(reduxStoryDecorator)
   .add('RestrictionEditor', () => <RestrictionEditorStory disabled={boolean('disabled', false)} />);
