import { classNames, Hint } from '@yandex-infracloud-ui/libs-next';
import { Switch } from '@yandex-data-ui/common';
import * as React from 'react';
import { hints } from './hints';
import classes from './RestrictionOption.module.css';
import { IRestriction } from './RestrictionValue';

interface Props {
   disabled: boolean;
   id: string;
   option: IRestriction;

   onToggle(r: IRestriction): void;
}

export const RestrictionOption: React.FC<Props> = ({ id, disabled, option: r, onToggle }) => {
   const HintComponent = hints[r.restriction] ?? null;

   return (
      <div key={r.restriction} className={classes.option}>
         <label
            className={classNames(
               {
                  [classes.group]: r.isGroup,
                  [classes.disabled]: disabled || r.implicit,
               },
               classes.label,
            )}
            htmlFor={id}
         >
            {r.restriction}
         </label>

         <Switch
            name={r.restriction}
            id={id}
            disabled={disabled || r.implicit}
            checked={r.enabled || r.implicit}
            onChange={() => onToggle(r)}
         />

         <Hint className={classes.hint} text={HintComponent ? <HintComponent /> : null} />
      </div>
   );
};

RestrictionOption.displayName = 'RestrictionOption';
