import { IRestriction, RestrictionValue } from './RestrictionValue';

describe('RestrictionValue', () => {
   const value = new Set(['y', 'z']);
   const restrictions = ['x', 'y', 'z', 'a', 'b', 'c'];
   const mapping = new Map([['x', ['a', 'b', 'c']]]);

   it('should return value', () => {
      const rv = new RestrictionValue(value, restrictions, mapping);

      expect(rv.valueOf()).toEqual(new Set(['y', 'z']));
   });

   it('should update immutable', () => {
      const rv = new RestrictionValue(value, restrictions, mapping);
      const rv2 = rv.update(new Set(['a', 'x']));

      expect(rv).not.toBe(rv2);
      expect(rv.valueOf()).toEqual(new Set(['y', 'z']));
      expect(rv2.valueOf()).toEqual(new Set(['a', 'x']));
   });

   it('should return array', () => {
      const rv = new RestrictionValue(value, restrictions, mapping);

      expect(rv.toArray()).toEqual([
         { enabled: false, implicit: false, isGroup: true, restriction: 'x' },
         { enabled: true, implicit: false, isGroup: false, restriction: 'y' },
         { enabled: true, implicit: false, isGroup: false, restriction: 'z' },
         { enabled: false, implicit: false, isGroup: false, restriction: 'a' },
         { enabled: false, implicit: false, isGroup: false, restriction: 'b' },
         { enabled: false, implicit: false, isGroup: false, restriction: 'c' },
      ] as IRestriction[]);
   });

   it('should toggle sub restriction', () => {
      const rv = new RestrictionValue(value, restrictions, mapping);

      const rv2 = rv.toggle('a');
      expect(rv2.toArray()).toEqual([
         { enabled: false, implicit: false, isGroup: true, restriction: 'x' },
         { enabled: true, implicit: false, isGroup: false, restriction: 'y' },
         { enabled: true, implicit: false, isGroup: false, restriction: 'z' },
         { enabled: true, implicit: false, isGroup: false, restriction: 'a' },
         { enabled: false, implicit: false, isGroup: false, restriction: 'b' },
         { enabled: false, implicit: false, isGroup: false, restriction: 'c' },
      ] as IRestriction[]);
   });

   it('should toggle group', () => {
      const rv = new RestrictionValue(value, restrictions, mapping);

      const rv2 = rv.toggle('x');
      expect(rv2.toArray()).toEqual([
         { enabled: true, implicit: false, isGroup: true, restriction: 'x' },
         { enabled: true, implicit: false, isGroup: false, restriction: 'y' },
         { enabled: true, implicit: false, isGroup: false, restriction: 'z' },
         { enabled: false, implicit: true, isGroup: false, restriction: 'a' },
         { enabled: false, implicit: true, isGroup: false, restriction: 'b' },
         { enabled: false, implicit: true, isGroup: false, restriction: 'c' },
      ] as IRestriction[]);
   });
});
