import React from 'react';

const docsBaseUrl = 'https://docs.yandex-team.ru/wall-e/';

function AutomatedDiskChangeHint() {
   return (
      <>
         <p>
            Запрещает{' '}
            <a href={`${docsBaseUrl}automation/algorithm#automatic-disk-changing`} target={'_blank'}>
               автоматическую замену дисков
            </a>
            .
         </p>
         <p>
            Wall-E не будет пытаться лечить диски у хостов с этим ограничением. Также на замену дисков влияет
            ограничение <code>automated-redeploy</code> (и все, которые его включают): если оно есть у хоста, но нет
            ограничения <code>automated-disk-change</code>, то замена дисков будет производиться только в том случае,
            если она не ведёт к потере данных.
         </p>
      </>
   );
}

function AutomatedDnsHint() {
   return (
      <p>
         Запрещает{' '}
         <a href={`${docsBaseUrl}automation/dns#dns-fixing`} target={'_blank'}>
            автоматическое исправление DNS-записей
         </a>{' '}
         хоста
      </p>
   );
}

function AutomatedHealingHint() {
   return (
      <>
         <p>Отключает автоматическое лечение хоста.</p>

         <p>
            Wall-E никогда не предпримет какие-либо действия автоматически - только по запросу от пользователя. Неявно
            включает в себя
            <code>automated-reboot</code>, <code>automated-profile</code>, <code>automated-redeploy</code>,{' '}
            <code>automated-memory-change</code>, <code>automated-disk-change</code> и{' '}
            <code>automated-link-repair</code>.
         </p>
      </>
   );
}

function AutomatedLinkRepairHint() {
   return (
      <>
         <p>
            Запрещает{' '}
            <a href={`${docsBaseUrl}automation/algorithm#automatic-link-repairing`} target={'_blank'}>
               автоматическую починку сетевого интерфейса
            </a>
            .
         </p>
         <p>
            Если Wall-E примет решение, что у хоста необходимо проверить сетевой интерфейс, то при наличии такого
            ограничения он вместо создания заявки в BOT просто переведёт хост в статус <code>dead</code>.
         </p>
      </>
   );
}

function AutomatedMemoryChangeHint() {
   return (
      <>
         <p>
            Запрещает{' '}
            <a href={`${docsBaseUrl}automation/algorithm#automatic-memory-changing`} target={'_blank'}>
               автоматическую замену памяти
            </a>
            .
         </p>
         <p>
            Если Wall-E примет решение, что у хоста необходимо поменять планку памяти, то при наличии такого ограничения
            он вместо замены памяти просто переведёт хост в статус <code>dead</code>.
         </p>
      </>
   );
}

function AutomatedProfileHint() {
   return (
      <>
         <p>
            Запрещает автоматическую{' '}
            <a href={`${docsBaseUrl}guide/hosts#host-profiling`} target={'_blank'}>
               преднастройку
            </a>{' '}
            хоста.
         </p>
         <p>
            Если Wall-E примет решение, что хост необходимо отправить в преднастройку, то при наличии такого ограничения
            он вместо преднастройки просто переведёт хост в статус <code>dead</code>.
         </p>
      </>
   );
}

function AutomatedRebootHint() {
   return (
      <>
         <p>
            Запрещает автоматический{' '}
            <a href={`${docsBaseUrl}guide/hosts#host-rebooting`} target={'_blank'}>
               ребут
            </a>{' '}
            хоста.
         </p>
         <p>
            Если Wall-E примет решение, что хост необходимо ребутнуть, то при наличии такого ограничения он вместо
            ребута просто переведёт хост в статус <code>dead</code>. Неявно включает в себя{' '}
            <code>automated-profile</code>, <code>automated-redeploy</code> и <code>automated-memory-change</code>,
            т.&nbsp;к. они требуют перезагрузки машины.
         </p>
      </>
   );
}

function AutomatedRedeployHint() {
   return (
      <>
         <p>
            Запрещает автоматическую{' '}
            <a href={`${docsBaseUrl}guide/hosts#host-deploying`} target={'_blank'}>
               переналивку
            </a>{' '}
            хоста.
         </p>
         <p>
            Если Wall-E примет решение, что хост необходимо переналить, то при наличии такого ограничения он вместо
            переналивки просто переведёт хост в статус <code>dead</code>.
         </p>
      </>
   );
}

function AutomationHint() {
   return (
      <>
         <p>Отключает всю автоматику для машины.</p>
         <p>
            {' '}
            Wall-E никогда не предпримет какие-либо действия автоматически - только по запросу от пользователя. Неявно
            включает в себя <code>automated-dns</code>, и <code>automated-healing</code>.
         </p>
      </>
   );
}

function ProfileHint() {
   return (
      <>
         <p>
            Запрещает{' '}
            <a href={`${docsBaseUrl}guide/hosts#host-profiling`} target={'_blank'}>
               преднастройку
            </a>{' '}
            хоста.
         </p>
         <p>
            Как ручную, так и автоматическую. Неявно включает в себя <code>automated-profile</code>.
         </p>
      </>
   );
}

function RebootHint() {
   return (
      <>
         <p>
            Запрещает{' '}
            <a href={`${docsBaseUrl}guide/hosts#host-rebooting`} target={'_blank'}>
               ребут
            </a>{' '}
            хоста.
         </p>
         <p>
            Как ручной, так и автоматический. Неявно включает в себя <code>automated-reboot</code>.
         </p>
      </>
   );
}

function RedeployHint() {
   return (
      <>
         <p>
            Запрещает{' '}
            <a href={`${docsBaseUrl}guide/hosts#host-deploying`} target={'_blank'}>
               переналивку
            </a>{' '}
            хоста.
         </p>
         <p>
            Как ручную, так и автоматическую. Неявно включает в себя <code>automated-redeploy</code>.
         </p>
      </>
   );
}

export const hints: { [key: string]: React.FC } = {
   'automated-disk-change': AutomatedDiskChangeHint,
   'automated-dns': AutomatedDnsHint,
   'automated-healing': AutomatedHealingHint,
   'automated-link-repair': AutomatedLinkRepairHint,
   'automated-memory-change': AutomatedMemoryChangeHint,
   'automated-profile': AutomatedProfileHint,
   'automated-reboot': AutomatedRebootHint,
   'automated-redeploy': AutomatedRedeployHint,
   automation: AutomationHint,
   profile: ProfileHint,
   reboot: RebootHint,
   redeploy: RedeployHint,
};
