import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { outlineDecorator } from '../../stories';

import { IButtonConfig, RowButtons } from './RowButtons';

import { DeleteIcon, PowerOffIcon } from 'design/icons';

const buttons: IButtonConfig[] = [
   { name: 'Turn off', icon: <PowerOffIcon />, handler: action('Turn off') },
   { name: 'Delete', icon: <DeleteIcon />, handler: action('Delete') },
];

storiesOf('shared', module)
   .addDecorator(outlineDecorator)
   .add('RowButtons', () => <RowButtons buttons={buttons} />);
