import { classNames } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
// noinspection TypeScriptPreferShortImport
import { FadeButton } from '../FadeButton/FadeButton';

import classes from './RowButtons.module.css';

export interface IButtonConfig {
   cls?: string;
   icon?: JSX.Element;
   name: string;

   handler(...args: any[]): void;
}

interface IProps {
   buttons: IButtonConfig[];
   cls?: string;
}

export const RowButtons = React.memo(({ cls, buttons }: IProps) => (
   <div className={cls}>
      {buttons.map(button => (
         <FadeButton
            key={button.name}
            text={button.name}
            onClick={button.handler}
            className={classNames(classes.button, button.cls)}
            icon={button.icon}
         />
      ))}
   </div>
));

RowButtons.displayName = 'RowButtons';
