import { classNames } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useCallback, useState } from 'react';
import { Link as ScrollLink } from 'react-scroll';

import classes from './MenuItem.module.css';

interface Props {
   containerId?: string;
   error?: string;
   id: string;
   offset?: number;
   title: string;
}

export const MenuItem = React.memo(({ containerId, id, title, error, offset = 0 }: Props) => {
   const [isActive, setIsActive] = useState(false);

   const onSetActive = useCallback((activeItem: string) => setIsActive(activeItem === id), [id]);

   const onSetInactive = useCallback(() => setIsActive(false), []);

   return (
      <li className={classNames(classes.item, { [classes.active]: isActive })}>
         <ScrollLink
            to={id}
            containerId={containerId}
            className={classes.link}
            spy={true}
            onSetActive={onSetActive}
            onSetInactive={onSetInactive}
            smooth={true}
            duration={250}
            isDynamic={true}
            offset={-offset}
         >
            {title}
         </ScrollLink>

         {error ? <div className={classes.error}>{error}</div> : null}
      </li>
   );
});

MenuItem.displayName = 'MenuItem';
