import * as React from 'react';
import { PropsWithChildren } from 'react';

import { Element as ScrollElement } from 'react-scroll';

import classes from './ScrollSection.module.css';

interface Props {
   error?: string;
   id: string;
   title: string;
}

export const ScrollSection = React.memo(({ id, title, children }: PropsWithChildren<Props>) => (
   <ScrollElement name={id} data-e2e={id}>
      <h2 className={classes.header}>{title}</h2>

      {children}
   </ScrollElement>
));

ScrollSection.displayName = 'ScrollSection';
