import React, { useEffect } from 'react';
import Scroll from 'react-scroll';

import { IStoryDefaults } from '../../stories/typings';
import { ScrollSection } from './ScrollSection';

import { SideScrollMenu } from './SideScrollMenu';

const Link = Scroll.Link;
// const DirectLink = Scroll.DirectLink;
const Element = Scroll.Element;
const Events = Scroll.Events;
const scroll = Scroll.animateScroll;
const scrollSpy = Scroll.scrollSpy;

function ReactScrollStory() {
   useEffect(() => {
      Events.scrollEvent.register('begin', (...args) => {
         console.log('begin', args);
      });

      Events.scrollEvent.register('end', (...args) => {
         console.log('end', args);
      });

      scrollSpy.update();

      return () => {
         Events.scrollEvent.remove('begin');
         Events.scrollEvent.remove('end');
      };
   }, []);

   const scrollToTop = () => scroll.scrollToTop();

   // @ts-ignore
   return (
      <div>
         <nav className={'navbar navbar-default navbar-fixed-top'}>
            <div className={'container-fluid'}>
               <div className={'collapse navbar-collapse'} id={'bs-example-navbar-collapse-1'}>
                  <ul className={'nav navbar-nav'}>
                     <li>
                        <input
                           onKeyDown={e => {
                              console.log('keydown');
                              scroll.scrollMore(500);
                           }}
                        />
                        <button onClick={() => scroll.scrollTo(100)}>Scroll To 100!</button>
                     </li>
                     <li>
                        <Link
                           activeClass={'active'}
                           to={'test3'}
                           spy={true}
                           hashSpy={true}
                           smooth={true}
                           duration={250}
                           isDynamic={true}
                        >
                           test3
                        </Link>
                     </li>
                  </ul>
               </div>
            </div>
         </nav>

         <div style={{ height: 500 }} />

         <Element name={'test1'} className={'element'}>
            test 1
         </Element>

         <Element name={'test2'} className={'element'}>
            test 2
         </Element>

         <Element name={'test3'} className={'element'}>
            test 3
         </Element>

         <Element name={'test4'} className={'element'}>
            test 4
         </Element>

         <Element name={'test5'} className={'element'}>
            test 5
         </Element>

         <div id={'anchor'} className={'element'}>
            test 6 (anchor)
         </div>

         <Link
            activeClass={'active'}
            to={'firstInsideContainer'}
            spy={true}
            smooth={true}
            duration={250}
            containerId={'containerElement'}
            style={{ display: 'inline-block', margin: '20px' }}
         >
            Go to first element inside container
         </Link>

         <Link
            activeClass={'active'}
            to={'secondInsideContainer'}
            spy={true}
            smooth={true}
            duration={250}
            containerId={'containerElement'}
            style={{ display: 'inline-block', margin: '20px' }}
         >
            Go to second element inside container
         </Link>

         <Element
            name={'test7'}
            className={'element'}
            id={'containerElement'}
            style={{
               height: '200px',
               marginBottom: '100px',
               overflow: 'scroll',
               position: 'relative',
            }}
         >
            test 7 (duration and container)
            <Element
               name={'firstInsideContainer'}
               style={{
                  marginBottom: '200px',
               }}
            >
               first element inside container
            </Element>
            <Element
               name={'secondInsideContainer'}
               style={{
                  marginBottom: '200px',
               }}
            >
               second element inside container
            </Element>
         </Element>

         <Element name={'same'} className={'element'}>
            Two links point to this
         </Element>

         <button onClick={scrollToTop}>To the top!</button>
      </div>
   );
}

export const Regular = () => (
   <SideScrollMenu>
      <ScrollSection id={'basic'} title={'Basic settings'} error={'Field errors in this block'}>
         <article style={{ height: 300 }}>Basic project settings form</article>
      </ScrollSection>

      <ScrollSection id={'cms'} title={'Cluster management system'}>
         <article style={{ height: 400 }}>Cluster management system form</article>
      </ScrollSection>

      <ScrollSection id={'vlans'} title={'VLANs'} error={'Field errors in this block'}>
         <article style={{ height: 600 }}>VLANs form</article>
      </ScrollSection>

      <ScrollSection id={'deploying'} title={'Deploying'}>
         <article style={{ height: 300 }}>Deploying form</article>
      </ScrollSection>

      <ScrollSection id={'profiling'} title={'Profiling'}>
         <article style={{ height: 300 }}>Profiling form</article>
      </ScrollSection>

      <ScrollSection id={'automation_limits'} title={'Automation limits'}>
         <article style={{ height: 300 }}>Automation limits form</article>
      </ScrollSection>

      <ScrollSection id={'checks'} title={'Checks'}>
         <article style={{ height: 300 }}>Checks form</article>
      </ScrollSection>

      <ScrollSection id={'restrictions'} title={'Host restrictions'}>
         <article style={{ height: 300 }}>Host restrictions form</article>
      </ScrollSection>

      <ScrollSection id={'notifications_report'} title={'Notifications and report'}>
         <article style={{ height: 300 }}>Notifications and report</article>
      </ScrollSection>
   </SideScrollMenu>
);

export const ReactScroll = () => <ReactScrollStory />;

export default {
   title: 'shared|SideScrollMenu',
} as IStoryDefaults;
