import { useBoundingClientRect } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { PropsWithChildren, useEffect } from 'react';
import { animateScroll } from 'react-scroll';

import { MenuItem } from './MenuItem';
import styles from './SideScrollMenu.module.css';

const containerId = 'scrollTrap';

export const SideScrollMenu = React.memo(({ children }: PropsWithChildren<{}>) => {
   const [ref, { top: offset }] = useBoundingClientRect();

   useEffect(() => {
      animateScroll.scrollTo(1, { containerId });
      animateScroll.scrollToTop({ containerId });
   }, []);

   const sections = React.Children.toArray(children)
      .filter((node: any) => node.type.displayName === 'ScrollSection')
      .map((section: any) => ({
         error: section.props.error,
         id: section.props.id,
         title: section.props.title,
      }));

   return (
      <div className={styles.menu} ref={ref}>
         <nav className={styles.nav}>
            <ul>
               {sections.map(s => (
                  <MenuItem
                     key={s.title}
                     id={s.id}
                     containerId={containerId}
                     offset={offset}
                     title={s.title}
                     error={s.error}
                  />
               ))}
            </ul>
         </nav>

         <div className={styles.content} id={containerId}>
            {children}
         </div>
      </div>
   );
});

SideScrollMenu.displayName = 'SideScrollMenu';
