import { classNames } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { PropsWithChildren, ReactNode } from 'react';

import classes from './Sidebar.module.css';

interface Props {
   content: ReactNode;
   footer?: ReactNode;
   isCollapsed: boolean;
}

export const Sidebar = React.memo(({ content, isCollapsed, footer, children }: PropsWithChildren<Props>) => (
   <div className={classNames(classes.wrapper, { [classes.collapsed]: isCollapsed })}>
      <div className={classes.sidebar}>
         <div className={classes.sidebarContent}>{content}</div>
         {footer ? <div className={classes.sidebarFooter}>{footer}</div> : null}
      </div>
      <div className={classes.page}>{children}</div>
   </div>
));

Sidebar.displayName = 'Sidebar';
