import { classNames } from '@yandex-infracloud-ui/libs-next';
import { ArrowRightIcon, ArrowLeftIcon } from 'design/icons';
import * as React from 'react';
import { useCallback } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { projectsSlice } from '../../state/projects';
import { RootState } from '../../state/store';
import { Button } from '@yandex-data-ui/common';

import classes from './SidebarToggleButton.module.css';

export enum SidebarDirection {
   Collapse = 'collapse',
   Expand = 'expand',
}

interface Props {
   className?: string;
   direction: SidebarDirection;
}

export const SidebarToggleButton = React.memo(({ className = '', direction }: Props) => {
   const sidebarCollapsed = useSelector((s: RootState) => s.projects.isCollapsed);
   const dispatch = useDispatch();

   const onSidebarToggle = useCallback(() => dispatch(projectsSlice.actions.toggleSidebar()), [dispatch]);

   if (direction === SidebarDirection.Expand && !sidebarCollapsed) {
      return null;
   }

   if (direction === SidebarDirection.Collapse && sidebarCollapsed) {
      return null;
   }

   return (
      <Button
         size={'l'}
         view={'raised'}
         pin={'circle-circle'}
         onClick={onSidebarToggle}
         className={classNames(className, {
            [classes.collapseButton]: direction === SidebarDirection.Collapse,
            [classes.expandButton]: direction === SidebarDirection.Expand,
         })}
         title={direction === SidebarDirection.Expand ? '' : 'Hide projects'}
      >
         {direction === SidebarDirection.Expand ? (
            <>
               Show projects <ArrowRightIcon />
            </>
         ) : (
            <ArrowLeftIcon />
         )}
      </Button>
   );
});

SidebarToggleButton.displayName = 'SidebarToggleButton';
