import React from 'react';

import { narrowDecorator } from '../../stories';
import { IStoryDefaults } from '../../stories/typings';
import { Skeleton, SkeletonItem, SkeletonPreset } from './Skeleton';

const items: SkeletonItem[] = [
   { size: SkeletonPreset.Medium, space: SkeletonPreset.Medium, width: '20%' },

   { size: SkeletonPreset.Large, space: SkeletonPreset.Small, width: '100%' },
   { size: SkeletonPreset.Large, space: SkeletonPreset.Small, width: '100%' },
   { size: SkeletonPreset.Large, space: SkeletonPreset.Large, width: '100%' },

   { size: SkeletonPreset.Medium, space: SkeletonPreset.Large, width: '60%' },

   { size: SkeletonPreset.Small, space: SkeletonPreset.Small, width: '100%' },
   { size: SkeletonPreset.Small, space: SkeletonPreset.Large, width: '60%' },

   { size: SkeletonPreset.Small, space: SkeletonPreset.Small, width: '100%' },
   { size: SkeletonPreset.Small, space: SkeletonPreset.Large, width: '60%' },
];

export const regular = () => <Skeleton items={items} />;

export default {
   decorators: [narrowDecorator],
   title: 'shared|Skeleton',
} as IStoryDefaults;
