import * as React from 'react';
import { CSSProperties } from 'react';

import styles from './Skeleton.module.css';

export enum SkeletonPreset {
   Small = 'small',
   Medium = 'medium',
   Large = 'large',
}

export interface SkeletonItem {
   size: SkeletonPreset | number;
   space: SkeletonPreset | number;
   width: number | string; // px | %
}

interface Props {
   items: SkeletonItem[];
}

const heightPresets = new Map<SkeletonPreset, number>([
   [SkeletonPreset.Small, 12],
   [SkeletonPreset.Medium, 16],
   [SkeletonPreset.Large, 29],
]);

const spacePresets = new Map<SkeletonPreset, number>([
   [SkeletonPreset.Small, 10],
   [SkeletonPreset.Medium, 21],
   [SkeletonPreset.Large, 32],
]);

export const Skeleton = React.memo(({ items }: Props) => {
   return (
      <div className={styles.skeleton}>
         {items.map((item, i) => {
            const style: CSSProperties = {
               height: typeof item.size === 'string' ? heightPresets.get(item.size)! : item.size,
               marginBottom: typeof item.space === 'string' ? spacePresets.get(item.space)! : item.space,
               width: item.width,
            };

            return <div key={i} className={styles.item} style={style} />;
         })}
      </div>
   );
});

Skeleton.displayName = 'Skeleton';
