import { classNames } from '@yandex-infracloud-ui/libs-next';
import React from 'react';

import styles from './SuggestSelectItem.module.css';

export const SuggestSelectItem = React.memo(
   ({ title, desc, group = false }: { title: string; desc?: string | null; group?: boolean }) => (
      <div
         className={classNames(styles.suggestItem, styles.withPaddings, {
            [styles.group]: group,
         })}
      >
         {title}
         {desc && <span className={styles.suggestItemTitle}>{desc}</span>}
      </div>
   ),
);

SuggestSelectItem.displayName = 'SuggestSelectItem';
