import { string } from 'prop-types';
import * as React from 'react';

interface IProps {
   active: string;

   id: string;
}

export class Tab extends React.PureComponent<IProps> {
   public static propTypes = {
      active: string.isRequired,
      id: string.isRequired,
   };

   public render() {
      if (this.props.active !== this.props.id) {
         return null;
      }

      return this.props.children;
   }
}
