/* tslint:disable:max-classes-per-file */
import { storiesOf } from '@storybook/react';
import { AppRoute, autobind, bindAndMemoize, json } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { PropsWithChildren, SyntheticEvent } from 'react';
import { Route, Switch } from 'react-router';

import { routerDecorator } from '../../stories';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { HostLinks } from '../HostLinks/HostLinks';

import { ITab } from './models';
import { Tab } from './Tab';
import { Tabs } from './Tabs';

class SimpleTabsStory extends React.PureComponent<PropsWithChildren<{}>, { tab: string }> {
   private _tabs: ITab[] = [
      { id: 'auto', header: 'Automation' },
      { id: 'checks', header: 'Checks', count: 2 },
      { id: 'settings', header: 'Presets' },
      { id: 'defaultSettings', header: 'Defaults' },
      { id: 'vlans', header: 'VLAN' },
   ];

   constructor(props: PropsWithChildren<{}>) {
      super(props);

      this.state = {
         tab: 'auto',
      };
   }

   public render() {
      const { tab } = this.state;

      return (
         <>
            <Tabs items={this._tabs} value={tab} onChange={this._onChange}>
               {this.props.children}
            </Tabs>

            <Tab id={'auto'} active={tab}>
               Содержимое вкладки про автоматику
            </Tab>

            <Tab id={'checks'} active={tab}>
               Содержимое вкладки про Проверки
            </Tab>

            <Tab id={'settings'} active={tab}>
               Содержимое вкладки про Преднастройки
            </Tab>

            <Tab id={'defaultSettings'} active={tab}>
               Содержимое вкладки про Параметры новых хостов
            </Tab>

            <Tab id={'vlan'} active={tab}>
               Содержимое вкладки про VLAN
            </Tab>

            <pre>{json(tab)}</pre>
            <button onClick={this._openTab('checks')}>Переключить на проверки</button>
         </>
      );
   }

   // noinspection JSUnusedLocalSymbols
   @autobind
   private _onChange(e: SyntheticEvent, tab: string) {
      this.setState({ tab });
   }

   @bindAndMemoize
   private _openTab(tab: string) {
      return () => {
         this.setState({ tab });
      };
   }
}

class RouteNavigationTabsStory extends React.Component {
   private _routes: AppRoute[] = [
      { path: '/storybook/tabs/first', component: () => <>первая вкладка</> },
      { path: '/storybook/tabs/second', component: () => <>вторая вкладка</> },
      { path: '/storybook/tabs/third', component: () => <>третья вкладка</> },
   ];

   private _tabs: ITab[] = [
      { id: 'first', header: 'Первая вкладка', url: '/storybook/tabs/first' },
      { id: 'second', header: 'Вторая вкладка', url: '/storybook/tabs/second' },
      { id: 'third', header: 'Третья вкладка', url: '/storybook/tabs/third' },
   ];

   public render() {
      const routes = this._routes.map(r => <Route key={r.path as string} to={r.path as string} {...r} />);

      return (
         <>
            <Tabs items={this._tabs} />

            <Switch>{routes}</Switch>
         </>
      );
   }
}

storiesOf('shared|Tabs', module)
   .addDecorator(routerDecorator)
   .add('Simple', () => <SimpleTabsStory />)
   .add('Simple With links', () => (
      <SimpleTabsStory>
         <HostLinks name={'xxx'} inv={123} />
      </SimpleTabsStory>
   ))
   .add('Routes', () => <RouteNavigationTabsStory />);
