import { classNames, formatNumber, IValueProps, toQuery } from '@yandex-infracloud-ui/libs-next';
import * as H from 'history';
import * as React from 'react';
import { PropsWithChildren } from 'react';
import { NavLink } from 'react-router-dom';

import { ITab } from './models';

import styles from './Tabs.module.css';

interface IProps extends Partial<IValueProps<string>> {
   commonParams?: {
      [key: string]: any;
   };
   items: ITab[];
   prev?: H.Location;
}

export const Tabs = React.memo(
   ({ children, commonParams = {}, items, prev, value, onChange }: PropsWithChildren<IProps>) => {
      // render
      const tabs = items.map(tab => {
         const tabContent = (
            <>
               {tab.header}
               {tab.count !== undefined ? <span className={styles.count}>{formatNumber(tab.count)}</span> : null}
            </>
         );

         return (
            <li key={tab.id}>
               {tab.url ? (
                  <NavLink
                     to={{ pathname: tab.url, search: toQuery(commonParams), state: { prev } }}
                     exact={tab.exact === undefined ? true : tab.exact}
                     className={styles.tab}
                     activeClassName={styles.active}
                  >
                     {tabContent}
                  </NavLink>
               ) : (
                  <button
                     className={classNames(styles.tab, {
                        [styles.active]: tab.id === value,
                     })}
                     onClick={e => onChange && onChange(e, tab.id)}
                  >
                     {tabContent}
                  </button>
               )}
            </li>
         );
      });

      return (
         <nav data-e2e={'Tabs'} className={styles.tabs}>
            <ul className={styles.tabList}>{tabs}</ul>
            {children}
         </nav>
      );
   },
);

Tabs.displayName = 'Tabs';
