/* tslint:disable:max-classes-per-file */
import { storiesOf } from '@storybook/react';
import { autobind, json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent } from 'react';
import { Observable, of } from 'rxjs';

import { narrowDecorator, outlineDecorator } from '../../stories';

import { TagInputEnhanced } from './TagInput';

class SimpleTagInputStory extends React.PureComponent<{}, { value: Set<string> }> {
   constructor(props: {}) {
      super(props);

      this.state = {
         value: new Set(['tag1', 'tag2']),
      };
   }

   public render() {
      return (
         <>
            <TagInputEnhanced value={this.state.value} onChange={this._onChange} />

            <pre>{json(this.state.value)}</pre>
         </>
      );
   }

   // noinspection JSUnusedLocalSymbols
   @autobind
   private _onChange(e: SyntheticEvent, value: Set<string>): void {
      this.setState({ value });
   }
}

class SuggestionsTagInputStory extends React.PureComponent<{}, { value: Set<string> }> {
   constructor(props: {}) {
      super(props);

      this.state = {
         value: new Set(['tag1', 'tag2']),
      };
   }

   public render() {
      return (
         <>
            <TagInputEnhanced
               value={this.state.value}
               onChange={this._onChange}
               getSuggestions={this._getSuggestions}
            />

            <pre>{json(this.state.value)}</pre>
         </>
      );
   }

   @autobind
   private _getSuggestions(term: string): Observable<string[]> {
      return of([term, term + '111', term + '222']);
   }

   // noinspection JSUnusedLocalSymbols
   @autobind
   private _onChange(e: SyntheticEvent, value: Set<string>): void {
      this.setState({ value });
   }
}

storiesOf('shared/TagInput', module)
   .addDecorator(outlineDecorator)
   .addDecorator(narrowDecorator)
   .add('Simple', () => <SimpleTagInputStory />)
   .add('Suggestions', () => <SuggestionsTagInputStory />);
