/* tslint:disable:max-classes-per-file */
import { storiesOf } from '@storybook/react';
import { autobind } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent } from 'react';

import { TagList } from './TagList';

class EditableTagListStory extends React.PureComponent<{}, { value: Set<string> }> {
   constructor(props: {}) {
      super(props);

      this.state = {
         value: new Set(['item 1', 'item 2', 'very very very very very very very very log item']),
      };
   }

   public render() {
      return <TagList value={this.state.value} editable={true} onChange={this._onChange} />;
   }

   // noinspection JSUnusedLocalSymbols
   @autobind
   private _onChange(e: SyntheticEvent, value: Set<string>) {
      this.setState({ value });
   }
}

class InvalidTagListStory extends React.PureComponent<{}, { value: Set<string> }> {
   constructor(props: {}) {
      super(props);

      this.state = {
         value: new Set(['item 1', 'item 2', 'very very very very very very very very log item']),
      };
   }

   public render() {
      return <TagList value={this.state.value} editable={true} />;
   }
}

storiesOf('shared/TagList', module)
   .add('Editable', () => <EditableTagListStory />)
   .add('Readonly', () => (
      <TagList
         value={new Set(['item 1', 'item 2', 'very very very very very very very very log item'])}
         editable={false}
      />
   ))
   .add('Wrapped', () => (
      <div style={{ maxWidth: '20rem', outline: '1px solid red' }}>
         <TagList
            value={
               new Set([
                  'item 1',
                  'item 2',
                  'item 3',
                  'item 4',
                  'item 5',
                  'item 6',
                  'item 7',
                  'item 8',
                  'very very very very very very very very log item',
               ])
            }
            editable={false}
         />
      </div>
   ))
   .add('Invalid (console.warn)', () => <InvalidTagListStory />);
