import { autobind, classNames, toggleSetItem } from '@yandex-infracloud-ui/libs-next';
import { Button } from '@yandex-data-ui/common';
import { bool, instanceOf } from 'prop-types';
import * as React from 'react';
import { SyntheticEvent } from 'react';

import styles from './TagList.module.css';
import { CloseIcon } from 'design/icons';

interface IOptionalOnChange {
   editable: boolean;

   onChange?(): void;
}

function optionalOnChange(props: IOptionalOnChange): Error | undefined {
   if (props.editable && !props.onChange) {
      return new Error('The `onChange` is required if editable is true');
   }
   if (props.onChange && typeof props.onChange !== 'function') {
      return new Error(`Invalid \`onChange\` of type ${typeof props.onChange}, expected function`);
   }

   return;
}

interface IProps {
   cls?: string;
   editable: boolean;
   value: Set<string>;

   onChange?(e: SyntheticEvent, v: Set<string>): void;
}

/**
 * @deprecated
 */
export class TagList extends React.PureComponent<IProps> {
   public static defaultProps = {
      cls: '',
   };

   public static propTypes = {
      editable: bool.isRequired,
      onChange: optionalOnChange,
      value: instanceOf(Set).isRequired,
   };

   public render() {
      const tags = Array.from(this.props.value).map(t => this._renderTag(t));

      return (
         <div
            className={classNames(styles.tagList, this.props.cls, {
               [styles.empty]: tags.length === 0,
            })}
         >
            {tags}
         </div>
      );
   }

   @autobind
   private _onDelete(item: string) {
      return (e: SyntheticEvent) => {
         const newValue = toggleSetItem(this.props.value, item);

         this.props.onChange!(e, newValue);
      };
   }

   private _renderTag(name: string) {
      let deleteButton = (
         <span className={styles.fakeButton}>
            <span />
         </span>
      );

      if (!this.props.editable) {
         deleteButton = (
            <Button view={'clear'} size={'m'} onClick={this._onDelete(name)}>
               <CloseIcon />
            </Button>
         );
      }

      return (
         <div key={name} className={styles.tag} title={name}>
            {name}
            {deleteButton}
         </div>
      );
   }
}
