import { action } from '@storybook/addon-actions';
import { IListOption } from '@yandex-infracloud-ui/libs-next';
import React from 'react';
import { IStoryDefaults } from '../../stories/typings';

import { TagList2 } from './TagList2';

const items: IListOption[] = [
   { value: 'id1', name: 'market' },
   { value: 'id2', name: 'RTC' },
   { value: 'id3', name: 'RTC network' },
   { value: 'id4', name: 'runtime' },
];

export const Readonly = () => <TagList2 editable={false} items={items} />;

export const Editable = () => <TagList2 editable={true} items={items} onRemove={action('onRemove')} />;

export const Wrapped = () => (
   <div style={{ width: '20rem' }}>
      <TagList2
         editable={false}
         items={[
            'item 1',
            'item 2',
            'item 3',
            'item 4',
            'item 5',
            'item 6',
            'item 7',
            'item 8',
            'very very very very very very very very log item',
         ].map(i => ({ name: i, value: i }))}
      />
   </div>
);

export default {
   // decorators: [fullWidthOutlineDecorator],
   title: 'shared|TagList2',
} as IStoryDefaults;
