import { classNames, IListOption } from '@yandex-infracloud-ui/libs-next';
import { Button } from '@yandex-data-ui/common';
import * as React from 'react';

import classes from './TagList2.module.css';
import { CloseIcon } from 'design/icons';

export function setToListOptions(v: Set<string>): IListOption[] {
   return Array.from(v).map(i => ({ value: i, name: i } as IListOption));
}

interface Props {
   className?: string;
   editable: boolean;
   items: IListOption[];

   onRemove?(id: string): void;
}

export const TagList2 = React.memo(({ className = '', editable, items, onRemove }: Props) => {
   if (editable && !onRemove) {
      throw new Error('Expected onRemove prop if TagList2 is editable');
   }

   return (
      <div className={classNames(classes.tagList, className)}>
         {items.map(item => (
            <div
               key={item.value}
               className={classNames(classes.tag, { [classes.editable]: editable })}
               title={`${item.name}${item.note ? `: ${item.note}` : ''}`}
            >
               {item.name}

               {editable ? (
                  <Button
                     view={'clear'}
                     size={'s'}
                     className={classes.removeButton}
                     onClick={() => onRemove!(item.value)}
                  >
                     <CloseIcon size={'sm'} />
                  </Button>
               ) : null}
            </div>
         ))}
      </div>
   );
});

TagList2.displayName = 'TagList2';
