import React from 'react';
import { TextInput, TextInputProps } from '@yandex-data-ui/common';
import { classNames } from '@yandex-infracloud-ui/libs-next';

import style from './TextInputSearch.module.css';
import { SearchIcon } from 'design/icons';

export const TextInputSearch = ({ ...props }: TextInputProps) => {
   return (
      <div className={style.root}>
         <TextInput {...props} size={'m'} className={classNames(props.className, style.input)} />
         <SearchIcon className={style.icon} />
      </div>
   );
};
